/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWDataField;
import filenet.vw.api.VWException;
import filenet.vw.api.VWRoster;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWRosterElement;
import filenet.vw.api.VWRosterQuery;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminElementTableModel;
import filenet.vw.toolkit.admin.result.VWAdminFieldsTableData;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminRosterElementTableData;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.admin.search.VWAdminPerformSearchEvent;
import java.util.Vector;

public abstract class VWAdminElementInRosterTableModel
extends VWAdminElementTableModel {
    protected VWRoster m_vwRoster = null;
    protected VWRosterElement m_curRosterElement = null;
    protected VWRosterQuery m_vwRosterQuery = null;
    protected String m_rosterName = null;

    public VWAdminElementInRosterTableModel(VWAdminResultPane resultsPane, VWAdminPerformSearchEvent event) {
        super(resultsPane, event);
        try {
            this.m_rosterName = event.getSelectedItem();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void startTheQuery() throws Exception {
        this.setQueryFlags(this.m_queryFlags);
        this.setQueryFetchType(4);
        this.m_vwRoster = this.m_vwSession.getRoster(this.m_rosterName);
        this.m_vwRoster.setBufferSize(this.m_maxReturned);
        this.m_vwRosterQuery = this.m_vwRoster.createQuery(this.m_queryIndexName, this.m_queryMinIndexValue, this.m_queryMaxIndexValue, this.m_queryFlags, this.m_queryFilter, this.m_querySubstitutionVars, this.m_queryFetchType);
        this.getExposedFieldsDefinition();
    }

    protected int fetchQueryCount() throws Exception {
        int count = -1;
        try {
            this.setQueryFlags(this.m_queryFlags);
            this.setQueryFetchType(4);
            this.m_vwRoster = this.m_vwSession.getRoster(this.m_rosterName);
            this.m_vwRoster.setBufferSize(this.m_maxReturned);
            this.m_vwRosterQuery = this.m_vwRoster.createQuery(this.m_queryIndexName, this.m_queryMinIndexValue, this.m_queryMaxIndexValue, this.m_queryFlags, this.m_queryFilter, this.m_querySubstitutionVars, this.m_queryFetchType);
            count = this.m_vwRosterQuery.fetchCount();
        }
        catch (Exception ex) {
            count = -1;
            throw ex;
        }
        return count;
    }

    protected void retrieveElements() throws Exception {
        VWRosterElement curElement = null;
        int rowNum = 0;
        try {
            this.m_elementCache.removeAllElements();
            for (rowNum = 0; rowNum < this.m_maxReturned && (curElement = (VWRosterElement)this.m_vwRosterQuery.next()) != null; ++rowNum) {
                VWAdminRosterElementTableData dataField = new VWAdminRosterElementTableData(curElement, this.m_logonUser, rowNum + 1, rowNum);
                this.m_elementCache.addElement(dataField);
            }
            if (rowNum > 0) {
                ++this.m_setNum;
            }
            if (this.m_vwRosterQuery.hasNext()) {
                this.setHasNext(true);
            } else {
                this.setHasNext(false);
            }
        }
        catch (OutOfMemoryError err) {
            throw new VWException("vw.toolkit.admin.result.outOfMemoryError", "Out of memory.  Please use a smaller maximum returned set.");
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    protected void buildObjectCache() {
        try {
            Object curWorkObject = null;
            if (this.m_objectCache != null) {
                this.m_objectCache.removeAllElements();
            }
            if (this.m_elementCache.size() > 0) {
                for (int i = 0; i < this.m_elementCache.size(); ++i) {
                    this.m_objectCache.addElement(this.m_elementCache.elementAt(i));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void buildAvailableColumnsList() {
        VWDataField[] vwDataFields = null;
        VWRosterElement curElement = null;
        Object curWorkObject = null;
        try {
            this.m_availableColumns.removeAllElements();
            for (int i = 0; i < this.m_objectCache.size(); ++i) {
                VWAdminRosterElementTableData woData = (VWAdminRosterElementTableData)this.m_objectCache.elementAt(i);
                curElement = (VWRosterElement)woData.getElement();
                vwDataFields = curElement.getDataFields();
                for (int j = 0; j < vwDataFields.length; ++j) {
                    if (this.isInVector(vwDataFields[j].getName(), this.m_availableColumns)) continue;
                    this.m_availableColumns.addElement(vwDataFields[j].getName());
                    this.m_availableFields.addElement(vwDataFields[j]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected Object getObjectAt(int rowIndex) {
        VWAdminRosterElementTableData obj = null;
        if (rowIndex > this.getRowCount() - 1) {
            return null;
        }
        obj = (VWAdminRosterElementTableData)this.m_objectCache.elementAt(rowIndex);
        return obj;
    }

    protected void retrieveRowData() {
        this.retrieveRowDataForRosterElement();
    }

    protected void retrieveRowData(int rowIndex) {
        this.retrieveRowDataForRosterElement(rowIndex);
    }

    protected void getExposedFieldsDefinition() throws Exception {
        VWRosterDefinition vwRosterDefinition = null;
        vwRosterDefinition = this.m_vwRoster.fetchRosterDefinition();
        this.m_vwFieldDefinitions = vwRosterDefinition == null ? null : vwRosterDefinition.getFields();
    }

    protected Object getFieldValue(VWRosterElement obj, String colName) {
        try {
            if (obj.hasFieldName(colName)) {
                return obj.getFieldValue(colName);
            }
            return VWResource.s_emptyString;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return VWResource.s_emptyString;
        }
    }

    private void retrieveRowDataForRosterElement() {
        VWRosterElement curElement = null;
        Vector<Object> rowData = null;
        String fieldName = null;
        Object fieldValue = null;
        VWAdminFieldsTableData dataField = null;
        VWDataField vwDataField = null;
        try {
            if (this.m_rowCache != null) {
                this.m_rowCache.removeAllElements();
            }
            for (int i = 0; i < this.m_objectCache.size(); ++i) {
                VWAdminRosterElementTableData woData = (VWAdminRosterElementTableData)this.m_objectCache.elementAt(i);
                curElement = (VWRosterElement)woData.getElement();
                rowData = new Vector<Object>();
                rowData.addElement(new Integer(woData.getDisplayRowIndex()));
                for (int col = 1; col < this.m_headers.size(); ++col) {
                    dataField = null;
                    fieldName = (String)this.m_headers.elementAt(col);
                    vwDataField = this.findDataFieldInElement(curElement, fieldName);
                    dataField = vwDataField != null ? new VWAdminFieldsTableData(vwDataField, curElement, this.m_vwSession, 0) : null;
                    rowData.addElement(dataField);
                }
                this.m_rowCache.addElement(rowData);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void retrieveRowDataForRosterElement(int rowIndex) {
        VWRosterElement curElement = null;
        Vector<Object> rowData = null;
        String fieldName = null;
        Object fieldValue = null;
        VWAdminFieldsTableData dataField = null;
        VWDataField vwDataField = null;
        try {
            VWAdminRosterElementTableData woData = (VWAdminRosterElementTableData)this.m_objectCache.elementAt(rowIndex);
            curElement = (VWRosterElement)woData.getElement();
            rowData = new Vector<Object>();
            rowData.addElement(new Integer(woData.getDisplayRowIndex()));
            for (int col = 1; col < this.m_headers.size(); ++col) {
                dataField = null;
                fieldName = (String)this.m_headers.elementAt(col);
                vwDataField = this.findDataFieldInElement(curElement, fieldName);
                dataField = vwDataField != null ? new VWAdminFieldsTableData(vwDataField, curElement, this.m_vwSession, 0) : null;
                rowData.addElement(dataField);
            }
            this.m_rowCache.setElementAt(rowData, rowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

